/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.shaders.Program;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.Helper;

public class ShaderCodeTransformation {
    private static final Pattern patternVoidMain = Pattern.compile("void ( )*main( )*\\(( )*( )*\\)( )*(\n)*\\{");
    private static List<Config> configs;

    private static boolean matches(ShaderType me, Program.Type type) {
        if (type == Program.Type.FRAGMENT) {
            return me == ShaderType.fs;
        }
        if (type == Program.Type.VERTEX) {
            return me == ShaderType.vs;
        }
        return false;
    }

    public static void init() {
        if (IPGlobal.enableClippingMechanism) {
            String json = McHelper.readTextResource(new ResourceLocation("immersive_portals:shaders/shader_transformation.json"));
            configs = (List)IPGlobal.gson.fromJson(json, new TypeToken<List<Config>>(){}.getType());
            Helper.log("Loaded Shader Code Transformation");
        } else {
            Helper.log("Shader Transformation Disabled");
        }
    }

    public static String transform(Program.Type type, String shaderId, String inputCode) {
        if (configs == null) {
            Helper.log("Shader Transform Skipping " + shaderId);
            return inputCode;
        }
        Config selected = ShaderCodeTransformation.getConfig(type, shaderId);
        if (selected == null) {
            return inputCode;
        }
        String result = inputCode;
        for (TransformationEntry entry : selected.transformations) {
            String replacement = String.join((CharSequence)"\n", entry.replacement);
            result = result.replaceAll(entry.pattern, replacement);
        }
        if (selected.debugOutput) {
            Helper.log("Shader Transformed " + shaderId + "\n" + result);
        }
        return result;
    }

    @Nullable
    private static Config getConfig(Program.Type type, String shaderId) {
        return configs.stream().filter(config -> ShaderCodeTransformation.matches(config.type, type) && config.affectedShaders.contains(shaderId)).findFirst().orElse(null);
    }

    public static boolean shouldAddUniform(String shaderName) {
        if (configs == null) {
            Helper.log("Shader Transform Skipping " + shaderName);
            return false;
        }
        return configs.stream().anyMatch(config -> config.affectedShaders.contains(shaderName));
    }

    public static enum ShaderType {
        vs,
        fs;

    }

    public static class Config {
        public ShaderType type;
        public Set<String> affectedShaders;
        public List<TransformationEntry> transformations;
        public boolean debugOutput;
    }

    public static class TransformationEntry {
        public String pattern;
        public List<String> replacement;
    }
}

